/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Window;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class IPSTool {
    static int IPSE_Patch = 1;
    static int IPSE_File = 2;
    Window parent;
    JDialog DlgProgress;
    int OrigIdx = -1;
    int PatchIdx = -1;
    RandomAccessFile OrigFile;
    RandomAccessFile PatchFile;
    RandomAccessFile LogFile;
    int Address;
    int NumBytes;
    int RLEBytes;
    int TotalChunks;
    char RLEByte;
    byte[] Buffer;
    boolean log;
    boolean backup;

    public IPSTool(Window p, File file, File patch, boolean filezip, boolean patchzip, boolean Log, boolean Backup) throws IOException {
        this.init(p, file, patch, Log, Backup);
    }

    public IPSTool(Window p, File file, File patch, boolean Log, boolean Backup) throws IOException {
        this.init(p, file, patch, Log, Backup);
    }

    /*
     * WARNING - void declaration
     */
    public void init(Window p, File file, File patch, boolean Log, boolean Backup) throws IOException {
        this.PatchFile = new RandomAccessFile(patch, "r");
        this.OrigFile = new RandomAccessFile(file, "rw");
        this.TotalChunks = 0;
        this.Address = 0;
        this.NumBytes = 0;
        this.RLEBytes = 0;
        this.log = Log;
        this.parent = p;
        if (this.log) {
            this.LogFile = new RandomAccessFile(patch.getParent() + File.separatorChar + "log.txt", "rw");
        }
        this.backup = Backup;
        if (this.backup) {
            int c;
            File outputFile = new File(file.getPath() + ".bak");
            FileReader in = new FileReader(file);
            FileWriter out = new FileWriter(outputFile.getPath(), false);
            while ((c = in.read()) != -1) {
                void var9_9;
                out.write((int)var9_9);
            }
            in.close();
            out.close();
        }
    }

    void GetNumBytes() throws IOException {
        int b2;
        int b1 = this.PatchFile.readUnsignedByte();
        this.NumBytes = b2 = this.PatchFile.readUnsignedByte();
        this.NumBytes += b1 * 256;
        if (this.NumBytes == 0) {
            this.GetRLE();
        }
    }

    boolean GetAddress() throws IOException {
        if (this.PatchIdx == -1) {
            int a1 = this.PatchFile.readUnsignedByte();
            int a2 = this.PatchFile.readUnsignedByte();
            int a3 = this.PatchFile.readUnsignedByte();
            if (a1 == 69 && a2 == 79 && a3 == 70) {
                return false;
            }
            ++this.TotalChunks;
            this.Address = 0;
            this.Address = a3;
            this.Address += a2 * 256;
            this.Address += a1 * 65536;
        }
        return true;
    }

    boolean isaIPS() throws IOException {
        this.Buffer = new byte[5];
        this.PatchFile.read(this.Buffer);
        return this.Buffer[0] == 80 && this.Buffer[1] == 65 && this.Buffer[2] == 84 && this.Buffer[3] == 67 && this.Buffer[4] == 72;
    }

    void GetChunk() throws IOException {
        this.Buffer = new byte[this.NumBytes];
        this.PatchFile.read(this.Buffer);
    }

    void ApplyPatch() throws IOException {
        this.OrigFile.seek(this.Address);
        this.OrigFile.write(this.Buffer, 0, this.NumBytes);
    }

    void ApplyRLE() throws IOException {
        this.OrigFile.seek(this.Address);
        int i = 0;
        while (i < this.NumBytes) {
            this.OrigFile.write(this.RLEByte);
            ++i;
        }
    }

    void GetRLE() throws IOException {
        int r1 = this.PatchFile.readUnsignedByte();
        int r2 = this.PatchFile.readUnsignedByte();
        int rb = this.PatchFile.readUnsignedByte();
        this.RLEBytes = r2;
        this.RLEBytes += r1 * 256;
        this.RLEByte = (char)rb;
    }

    public void patch() {
        try {
            if (this.isaIPS()) {
                if (this.log) {
                    this.LogFile.writeBytes("JIPS 3.0 Logfile\nTo have news about JIPS and other ZeroSoft Projects\nvisit: http://zerosoft.zophar.net\n\n");
                }
                while (this.GetAddress()) {
                    this.GetNumBytes();
                    if (this.NumBytes != 0) {
                        this.GetChunk();
                    }
                    if (this.NumBytes != 0) {
                        this.ApplyPatch();
                        if (!this.log) continue;
                        this.LogFile.writeBytes("Chunk number: " + Integer.toString(this.TotalChunks) + " Offset: " + Integer.toHexString(this.Address) + " Bytes: " + Integer.toHexString(this.NumBytes) + "\n");
                        continue;
                    }
                    this.ApplyRLE();
                    if (!this.log) continue;
                    this.LogFile.writeBytes("Chunk number: " + Integer.toString(this.TotalChunks) + " Offset: " + Integer.toHexString(this.Address) + " Bytes: " + Integer.toHexString(this.NumBytes) + " RLE char: " + Integer.toHexString(this.RLEByte) + " Lenght: " + Integer.toString(this.RLEBytes) + "\n");
                }
                JOptionPane.showMessageDialog(this.parent, "Patching Complete!\nPatches applied: " + this.TotalChunks);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parent, "An error occurred during patching:\n" + e.getMessage());
        }
    }
}

